<?php

class DB
{

	private static $_initialized = FALSE;
	/**
	 * @var PDO
	 */
	private static $_connection = FALSE;

	public static function connect()
	{
		if (!self::$_initialized) {
			self::$_initialized = TRUE;

			try {
				self::$_connection = new PDO('mysql:host=localhost;dbname=zsl_blog', 'root');
			} catch (PDOException $e) {
				throw new Exception('Nie można połączyć z PDO ' . $e->getMessage());
				return FALSE;
			}

			if (!self::$_connection) {
				throw new Exception('Nie można połączyć z PDO');
				return FALSE;
			}
		}
	}

	public static function connected()
	{
		return (bool)self::$_connection;
	}

	/**
	 * @param $sql
	 * @param bool $single
	 * @return array
	 * @throws Exception
	 */
	public static function query($sql, $single = false)
	{
		$result = self::$_connection->query($sql, PDO::FETCH_CLASS, 'stdClass');
		$results = array();

		if (!$result) {
			if (self::$_connection->errorCode()) {
				throw new Exception($sql . '<br/>' . implode(': ', self::$_connection->errorInfo()));
			}
		}

		foreach($result as $row) {
			$results[] = $row;
		}

        if ($single === true and count($results) > 0) {
            return $results[0];
        }

		return new ArrayObject($results);
	}

    public static function scalar($sql) {
        $result = (array) self::query($sql, true);
        if (count($result)) {
            return array_pop($result);
        }
        return null;
    }

	public static function update($sql)
	{
		$result = self::$_connection->exec($sql);
		if ($result === FALSE) {
			throw new Exception('Błąd zapytania<br/>' . $sql . '<br/>' . var_export(self::$_connection->errorInfo(), true));
			return NULL;
		} else {
			return $result;
		}
	}

	public static function lastId()
	{
		return self::$_connection->lastInsertId();
	}

	public static function close()
	{
		self::$_connection = NULL;
	}

	public static function protect($str)
	{
		$str = str_replace("'", "''", $str);
		$str = str_replace('\\', '\\\\', $str);

		return $str;
	}

}
